﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;

public partial class Admin_NeiRong_DaoRuLanMu : System.Web.UI.Page
{
    private 访问 访问;
    private String 栏目类型;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("网站后台", "网站后台", "网站后台", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();


        switch (Request.QueryString["ti"])
        {
            case "_1":
                栏目类型 = "文章";
                break;
            case "_2":
                栏目类型 = "图片";
                break;
            case "_3":
                栏目类型 = "软件";
                break;
            case "_4":
                栏目类型 = "音乐";
                break;
            case "_5":
                栏目类型 = "视频";
                break;
        }

        if (this.IsPostBack)
            导入栏目();
    }

    private void 删除栏目()
    {
        DataSet 数据 = (DataSet)Application["UUN_UUN3G_NeiRongLanMu"];

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (行["栏目类型"].ToString() == 栏目类型 && Convert.ToInt32(行["所属栏目"]) == 0)
                删除栏目(Convert.ToInt32(行["ID"]));
        }
    }

    private void 导入栏目()
    {
        访问.验证权限("9");
        if (Request.Form["sub"] == "导入并删除现有栏目")
            删除栏目();
        HttpPostedFile HF = LanMuWenJian.PostedFile;
        if (HF.ContentLength < 1)
            throw new Exception("请上传正确的栏目文件");

        常用.上传文件(HF,Server.MapPath("~/Temp/Temp_" + 栏目类型 + "栏目.rar"));

        DataSet 数据 = (DataSet)Application["UUN_UUN3G_NeiRongLanMu"];
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            SqlCommand 语句 = new SqlCommand("INSERT INTO [" + 程序.数据表前缀 + "内容_栏目]([ID],[栏目名称],[栏目类型],[所属栏目],[是否拥有子栏目],[外部链接地址],[默认排序方式],[模板_内容列表],[模板_3G内容列表],[模板_查看内容],[模板_3G查看内容],[模板_评论列表],[模板_3G评论列表],[栏目简介],[是否隐藏])" +
                "VALUES(@ID,@栏目名称,@栏目类型,@所属栏目,@是否拥有子栏目,@外部链接地址,@默认排序方式,@模板_内容列表,@模板_3G内容列表,@模板_查看内容,@模板_3G查看内容,@模板_评论列表,@模板_3G评论列表,@栏目简介,@是否隐藏)", 访问.连接);
            语句.Parameters.Add("@ID", SqlDbType.Int).Value = Convert.ToInt32(行["ID"]);
            语句.Parameters.Add("@栏目名称", SqlDbType.NVarChar).Value = 行["栏目名称"].ToString();
            语句.Parameters.Add("@栏目类型", SqlDbType.NVarChar).Value = 行["栏目类型"].ToString();
            语句.Parameters.Add("@所属栏目", SqlDbType.Int).Value = 行["所属栏目"].ToString();
            语句.Parameters.Add("@是否拥有子栏目", SqlDbType.Bit).Value = Convert.ToBoolean(行["是否拥有子栏目"]);
            语句.Parameters.Add("@外部链接地址", SqlDbType.NVarChar).Value = 行["外部链接地址"].ToString();
            语句.Parameters.Add("@默认排序方式", SqlDbType.NVarChar).Value = 行["默认排序方式"].ToString();
            语句.Parameters.Add("@模板_内容列表", SqlDbType.Int).Value = Convert.ToInt32(行["模板_内容列表"]);
            语句.Parameters.Add("@模板_3G内容列表", SqlDbType.Int).Value = Convert.ToInt32(行["模板_3G内容列表"]);
            语句.Parameters.Add("@模板_查看内容", SqlDbType.Int).Value = Convert.ToInt32(行["模板_查看内容"]);
            语句.Parameters.Add("@模板_3G查看内容", SqlDbType.Int).Value = Convert.ToInt32(行["模板_3G查看内容"]);
            语句.Parameters.Add("@模板_评论列表", SqlDbType.Int).Value = Convert.ToInt32(行["模板_评论列表"]);
            语句.Parameters.Add("@模板_3G评论列表", SqlDbType.Int).Value = Convert.ToInt32(行["模板_3G评论列表"]);
            语句.Parameters.Add("@栏目简介", SqlDbType.NVarChar).Value = 行["栏目简介"].ToString();
            语句.Parameters.Add("@是否隐藏", SqlDbType.Bit).Value = Convert.ToBoolean(行["是否隐藏"]);
            语句.ExecuteNonQuery();
        }
        File.Delete(Server.MapPath("~/Temp/Temp_" + 栏目类型 + "栏目.rar"));

        访问统计_管理记录 管理记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        管理记录.记录("导入栏目", 访问.用户["昵称"].ToString());
        更新缓存数据 更新缓存 = new 更新缓存数据(this.Context, 访问.连接);
        更新缓存.内容栏目_更新();
        Label1.Text = "栏目导入成功";
    }

    private void 删除栏目(int ID)
    {
        SqlCommand 语句 = new SqlCommand("SELECT [栏目类型] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [ID]=" + ID, 访问.连接);
        SqlDataReader 读取 = 语句.ExecuteReader();
        if (读取.Read())
        {
            String 栏目类型 = Convert.ToString(读取["栏目类型"]);
            读取.Close();
            switch (栏目类型)
            {
                case "文章":
                    删除栏目文章(ID);
                    break;
                case "图片":
                    删除栏目图片(ID);
                    break;
                case "软件":
                    删除栏目软件(ID);
                    break;
                case "音乐":
                    删除栏目音乐(ID);
                    break;
                case "视频":
                    删除栏目视频(ID);
                    break;
            }
        }
        else
            读取.Close();
        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [ID]=@ID", 访问.连接);
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ID;
        语句.ExecuteNonQuery();

        DataSet 数据 = new DataSet();
        语句 = new SqlCommand("SELECT [ID] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [所属栏目]=@所属栏目", 访问.连接);
        语句.Parameters.Add("@所属栏目", SqlDbType.Int).Value = ID;
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "内容栏目");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除栏目(Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除栏目文章(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[文件资源] FROM [" + 程序.数据表前缀 + "内容_文章_文章] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "文章");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除文章(Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除文章(String 文件资源, int ID)
    {
        if (文件资源 != null)
        {
            String[] 文件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
            for (int i = 0; i < 文件数组.Length; i++)
                if (File.Exists(Server.MapPath(文件数组[i])))
                    File.Delete(Server.MapPath(文件数组[i]));
        }

        File.Delete(Server.MapPath(程序.安装位置 + "Data/DT_WenZhang/" + (ID /500) + "/" + ID + ".txt"));

        SqlCommand 语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_评论] WHERE [内容类型]='文章' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_文章_文章] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 删除栏目图片(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[文件资源] FROM [" + 程序.数据表前缀 + "内容_图片_图片] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "图片");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除图片(Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除图片(String 文件资源, int ID)
    {

        if (文件资源 != null)
        {
            String[] 文件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
            for (int i = 0; i < 文件数组.Length; i++)
                if (File.Exists(Server.MapPath(文件数组[i])))
                    File.Delete(Server.MapPath(文件数组[i]));
        }
        File.Delete(Server.MapPath(程序.安装位置 + "Data/DT_TuPian/" + (ID /500) + "/" + ID + ".Xml"));

        SqlCommand 语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_评论] WHERE [内容类型]='图片' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_图片_图片] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 删除栏目软件(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[图片文件],[文件资源] FROM [" + 程序.数据表前缀 + "内容_软件_软件] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "软件");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除软件(Convert.ToString(数据.Tables[0].Rows[i]["图片文件"]),
                Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除软件(String 图片文件, String 文件资源, int ID)
    {

        String[] 图片数组 = 图片文件.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 图片数组.Length; i++)
            if (File.Exists(Server.MapPath(图片数组[i])))
                File.Delete(Server.MapPath(图片数组[i]));

        String[] 软件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 软件数组.Length; i++)
            if (File.Exists(Server.MapPath(软件数组[i])))
                File.Delete(Server.MapPath(软件数组[i]));

        File.Delete(Server.MapPath(程序.安装位置 + "Data/DT_RuanJian/" + (ID /500) + "/" + ID + ".Xml"));

        SqlCommand 语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_评论] WHERE [内容类型]='软件' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_软件_软件] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 删除栏目音乐(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[文件资源] FROM [" + 程序.数据表前缀 + "内容_音乐_音乐] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "音乐");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除音乐(Convert.ToString(数据.Tables[0].Rows[i]["文件资源"]),
                Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]));
    }

    private void 删除音乐(String 文件资源, int ID)
    {

        String[] 文件数组 = 文件资源.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 文件数组.Length; i++)
            if (File.Exists(Server.MapPath(文件数组[i])))
                File.Delete(Server.MapPath(文件数组[i]));

        SqlCommand 语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_评论] WHERE [内容类型]='音乐' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_音乐_音乐] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }

    private void 删除栏目视频(int 栏目ID)
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[视频图片],[视频文件] FROM [" + 程序.数据表前缀 + "内容_视频_视频] WHERE [所属栏目]=" + 栏目ID, 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "视频");

        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
            删除视频(Convert.ToInt32(数据.Tables[0].Rows[i]["ID"]),
                Convert.ToString(数据.Tables[0].Rows[i]["视频图片"]),
                Convert.ToString(数据.Tables[0].Rows[i]["视频文件"]));
    }

    private void 删除视频(int ID, String 视频图片, String 视频文件)
    {
        String[] 图片数组 = 视频图片.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 图片数组.Length; i++)
            File.Delete(Server.MapPath(图片数组[i]));
        String[] 文件数组 = 视频文件.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < 文件数组.Length; i++)
            File.Delete(Server.MapPath(文件数组[i]));

        SqlCommand 语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_评论] WHERE [内容类型]='视频' AND [内容ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();

        语句 = new SqlCommand("DELETE FROM [" + 程序.数据表前缀 + "内容_视频_视频] WHERE [ID]=" + ID, 访问.连接);
        语句.ExecuteNonQuery();
    }
}
